/*
This do file replicates Figure ## Exchange Rates during 2022-2023 FED Hikes

Because of confidentiality issues, we are not providing IAPOC data. Hence, we provide
the code even it can't be run. We include excel files with aggregate date to reproduce
the figure.

*/

clear
set more off
set graphics on
cls
clear matrix
clear mata 
set maxvar 8000

//Change this directory depending who is running the code
cap cd "Replication_pkg/Data_programs/Data"  

use "LP_data", clear
/*******************************************************************************
Drop LICS+ 
*******************************************************************************/
drop if IMF_incomeLevel==3
drop if Name=="Bolivia"
drop if Name=="Cambodia"
drop if Name=="Dominican Republic"
drop if Name=="Jamaica"
drop if Name=="Mongolia"
drop if Name=="Nicaragua"
xtset IFS_code time_q 
//ER growth 
g ler=ln(ER_avg_IFS) 
g g_er=100*(D.ler) //ER q to q
*keep if iapoc_sample==1 
drop iapoc 
//Replace by first or last iapoc value
global relevant_iapoc "iapoc_last"
ren $relevant_iapoc iapoc
*ren iapoc_last iapoc

sum iapoc if year(dofq(time_q))==2007 & iapoc_sample==1, d 
global min_iapoc=r(p25) //Replace by p25
global max_iapoc=r(p75) //Replace by p75 

g low=1 if (iapoc<=$min_iapoc)
replace low=0 if iapoc>=$max_iapoc
replace low=. if iapoc_sample==.

sort Name time_q 
keep if time_q>=tq(2022q1)
bys IFS_code (time_q): g nER=g_er-g_er[1]
cd "../../Figures/Figure 18"
preserve 
collapse (mean) nER, by(low time_q)
drop if low==.
line nER time_q if low==0 , lc(blue)  lwidth(thick) lp(dash)  ///
	|| (line nER time_q if low==1, lc(red) lp(dash) lwidth(thick)),  ///
	xtitle("") xlab(, nogrid)  xlabel(#5, angle(0))  ///
	ytitle("p.p changes") ylab(, nogrid)  ///
	ti("ER depreciations", size(medium)) ///
	legend(pos(6) label (1 "High credibility") ///
	label (2 "Low credibility") cols(2)) plotregion(style(none)) name(ner_cred,replace) aspect(0.7)	
reshape wide nER, i(time_q) j(low)
ren nER0 nER_High
ren nER1 nER_Low
tempfile data1 
save `data1', replace 
restore 
/*
EM AE
*/
collapse (mean) nER, by(EM time_q)
drop if EM==.
line nER time_q if EM==0 , lc(blue)  lwidth(thick) lp(dash)  ///
	|| (line nER time_q if EM==1, lc(red) lp(dash) lwidth(thick)),  ///
	xtitle("") xlab(, nogrid)  xlabel(#5, angle(0))  ///
	ytitle("p.p changes") ylab(, nogrid)  ///
	ti("ER depreciations", size(medium)) ///
	legend(pos(6) label (1 "AE") ///
	label (2 "EM") cols(2)) plotregion(style(none)) name(ner_em,replace) aspect(0.7)	
	
reshape wide nER, i(time_q) j(EM)
ren nER0 nER_AE
ren nER1 nER_EM	
tempfile data2 
save `data2', replace 
 
graph combine ner_em ner_cred, plotregion(margin(zero)) graphr(margin(zero))
graph export "Fig18.pdf", replace 

//Export to excel 
use `data1', clear 
merge 1:1 time_q using `data2', nogen 

export excel using "Fig18.xlsx", sheet("Fig18 data") replace firstrow(variables)


